/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.biome;

import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import xaero.map.biome.BiomeInfoSupplier;
import xaero.map.biome.BiomeKey;
import xaero.map.cache.BlockStateColorTypeCache;
import xaero.map.region.MapBlock;
import xaero.map.region.Overlay;

public class WriterBiomeInfoSupplier
implements BiomeInfoSupplier {
    private MapBlock currentPixel;
    private boolean canReuseBiomeColours;
    private BlockPos mutableGlobalPos;

    public WriterBiomeInfoSupplier(BlockPos mutableGlobalPos) {
        this.mutableGlobalPos = mutableGlobalPos;
    }

    public void set(MapBlock currentPixel, boolean canReuseBiomeColours) {
        this.currentPixel = currentPixel;
        this.canReuseBiomeColours = canReuseBiomeColours;
    }

    @Override
    public BiomeKey getBiomeInfo(BlockStateColorTypeCache colorTypeCache, World world, BlockState state, BlockPos pos, int[] biomeBuffer, BiomeKey blockBiome, MutableRegistry<Biome> biomeRegistry) {
        MapBlock currentPixel = this.currentPixel;
        if (this.canReuseBiomeColours && currentPixel != null && currentPixel.getNumberOfOverlays() > 0 && currentPixel.getOverlays().get(0).getState() == state) {
            Overlay currentTopOverlay = currentPixel.getOverlays().get(0);
            biomeBuffer[0] = currentTopOverlay.getColourType();
            blockBiome = currentTopOverlay.getColourType() == 1 ? currentPixel.getBiome() : null;
            biomeBuffer[2] = currentTopOverlay.getCustomColour();
        } else {
            blockBiome = colorTypeCache.getBlockBiomeColour(world, state, this.mutableGlobalPos, biomeBuffer, blockBiome, biomeRegistry);
        }
        return blockBiome;
    }
}

